#!/usr/bin/env python
# coding: utf-8

# In[20]:


from PIL import Image,ImageEnhance
from PIL import ImageFilter
from PIL import ImageOps
import numpy as np  


# In[21]:


def read():
    image=Image.open('image.png')
    width,height=image.size
    print(width,height)


# In[22]:


def show():
    image=Image.open('image.png')
    width,height=image.size
    image.show()


# In[23]:


def crop():
    image=Image.open('image.png')
    width,height=image.size
    top=0
    left=0
    right=width
    bottom=height/2
    img1=image.crop((left,top,right,bottom))
    img1.save('crop_image.png')
    img1.show()


# In[24]:


def flip():
    image=Image.open('image.png')
    flip=ImageOps.flip(image)
    flip.save("flip.png")
    flip.show()


# In[25]:


def rotate():
    image=Image.open('image.png')
    print("Image Rotation")
    n=float(input("Enter the angle"))
    rotate=image.rotate(n)
    rotate.save('rotate.png')
    rotate.show()


# In[26]:


def filters():
    image=Image.open('image.png')
    image=image.convert('RGB')
    contour=image.filter(ImageFilter.CONTOUR) 
    contour.save('contour.png')
    contour.show()
    detail=image.filter(ImageFilter.DETAIL) 
    detail.save('contour.png')
    detail.show()
    inverted_image=ImageOps.invert(image)
    inverted_image.save('inverted_color.png')
    inverted_image.show()
    enhance=image.filter(ImageFilter.EMBOSS)
    enhance.save("enhance.png")
    enhance.show()


# In[27]:


def basic_tools():
    image=Image.open('image.png')
    image=image.convert('RGB')
    k=float(input('Enter the brightness amount'))
    i4=ImageEnhance.Brightness(image)
    bright=i4.enhance(k).show()
    s=float(input("Enter the sharpness amount"))
    i5=ImageEnhance.Sharpness(image)
    sharp=i5.enhance(s).show()
    d=float(input("Enter the color amount"))
    i6=ImageEnhance.Color(image)
    color=i6.enhance(s).show()
    h=float(input("Enter contrast amount"))
    i7=ImageEnhance.Contrast(image)
    contrast=i7.enhance(h).show() 


# In[29]:


if __name__ == '__main__':
    read()
    show()
    crop()
    flip()
    rotate()
    filters()
    basic_tools()


# In[ ]:




